/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.html;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringEscapeUtils;

public class HtmlTag {
    private final boolean isFtl;
    @Nonnull
    private final String name;
    private String text;
    private final List<String> classes = new ArrayList<String>();
    private final List<String> styles = new ArrayList<String>();
    private final List<String> attributes = new ArrayList<String>();
    private final List<HtmlTag> children = new ArrayList<HtmlTag>();

    private HtmlTag(@Nonnull String name, boolean isFtl) {
        this.isFtl = isFtl;
        this.name = name;
    }

    public static HtmlTag createFromFtl(@Nonnull String ftlName) {
        Preconditions.checkNotNull(ftlName);
        return new HtmlTag(ftlName, true);
    }

    public static HtmlTag createTag(@Nonnull String tagName) {
        Preconditions.checkNotNull(tagName);
        return new HtmlTag(tagName, false);
    }

    public static HtmlTag createTag(@Nonnull String tagName, @Nonnull String classes) {
        Preconditions.checkNotNull(tagName);
        Preconditions.checkNotNull(classes);
        return HtmlTag.createTag(tagName).addClass(classes);
    }

    public static HtmlTag createButton(@Nonnull String classes) {
        Preconditions.checkNotNull(classes);
        return HtmlTag.createTag("button", classes).addAttribute("type", "button");
    }

    public static HtmlTag createIconButton(@Nonnull String classes, @Nonnull String title, @Nonnull String iconClass) {
        Preconditions.checkNotNull(classes);
        Preconditions.checkNotNull(title);
        Preconditions.checkNotNull(iconClass);
        HtmlTag button = HtmlTag.createButton(classes).addAttribute("title", title);
        HtmlTag icon = HtmlTag.createTag("i", iconClass);
        button.addChild(icon);
        return button;
    }

    public static HtmlTag createInInput(@Nullable String id, @Nullable String classes, @Nullable String label, @Nullable List<InputAttribute> attributes, @Nullable String hint, @Nullable Integer minChWidth) {
        HtmlTag wrapper = HtmlTag.createTag("div", "intextfield_wrapper");
        if (!Strings.isNullOrEmpty(id)) {
            wrapper.addAttribute("id", id);
        }
        if (classes != null) {
            wrapper.addClass(classes);
        }
        HtmlTag input = HtmlTag.createTag("input", "intextfield");
        if (attributes != null) {
            attributes.forEach(a -> input.addAttribute(a.name, a.value));
        }
        if (minChWidth != null) {
            input.addStyle("min-width", "calc(" + minChWidth + "ch + 2rem");
        }
        wrapper.addChild(input);
        if (!Strings.isNullOrEmpty(label)) {
            wrapper.addChild(HtmlTag.createTag("label").setText(label));
        }
        if (!Strings.isNullOrEmpty(hint)) {
            wrapper.addChild(HtmlTag.createTag("div", "iniput_helper_text").setText(hint));
        }
        return wrapper;
    }

    public static HtmlTag createInComboBox(@Nullable String id, @Nullable String classes, @Nullable String label, @Nonnull List<SelectOption> options, @Nullable String hint, @Nullable Integer minChWidth) {
        HtmlTag input = HtmlTag.createInInput(id, classes, label, null, hint, minChWidth);
        HtmlTag listWrapper = HtmlTag.createTag("div", "incombobox_list_wrapper");
        HtmlTag list = HtmlTag.createTag("div", "incombobox_list").addAttribute("tabindex", "0");
        options.forEach(o -> {
            HtmlTag item = HtmlTag.createTag("div", "incombobox_list_item").addAttribute("data-value", o.value).addChild(HtmlTag.createTag("div", "incombobox_list_item_text").setText(o.text));
            list.addChild(item);
        });
        listWrapper.addChild(list);
        input.addChild(listWrapper);
        return input;
    }

    public HtmlTag addClass(@Nonnull String className) {
        Preconditions.checkNotNull(className);
        this.classes.add(className);
        return this;
    }

    public HtmlTag addStyle(@Nonnull String style) {
        Preconditions.checkNotNull(style);
        this.styles.add(style);
        return this;
    }

    public HtmlTag addStyle(@Nonnull String name, @Nonnull String value) {
        Preconditions.checkNotNull(name);
        Preconditions.checkNotNull(value);
        this.addStyle(name + ":" + value);
        return this;
    }

    public HtmlTag addAttribute(@Nonnull String attribute, @Nullable String value) {
        Preconditions.checkNotNull(attribute);
        if (value == null) {
            this.addAttribute(attribute);
            return this;
        }
        this.attributes.add(attribute + "=\"" + StringEscapeUtils.escapeHtml(value) + "\"");
        return this;
    }

    public HtmlTag addAttribute(@Nonnull String attribute) {
        Preconditions.checkNotNull(attribute);
        this.attributes.add(attribute);
        return this;
    }

    public HtmlTag addChild(@Nonnull HtmlTag child) {
        Preconditions.checkNotNull(child);
        this.children.add(child);
        return this;
    }

    public boolean isFtl() {
        return this.isFtl;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public List<HtmlTag> getChildren() {
        return this.children;
    }

    @Nonnull
    public String getFront() {
        String front = "<" + this.name;
        if (!this.classes.isEmpty()) {
            front = front + " class=\"" + String.join((CharSequence)" ", this.classes) + "\"";
        }
        if (!this.styles.isEmpty()) {
            front = front + " style=\"" + String.join((CharSequence)";", this.styles) + "\"";
        }
        if (!this.attributes.isEmpty()) {
            front = front + " " + String.join((CharSequence)" ", this.attributes);
        }
        front = front + ">";
        return front;
    }

    @Nonnull
    public String getEnd() {
        return (!Strings.isNullOrEmpty(this.text) ? this.text : "") + "</" + this.name + ">";
    }

    public HtmlTag setText(String text) {
        this.text = StringEscapeUtils.escapeHtml(text);
        return this;
    }

    public HtmlTag setTextOrNbsp(@Nullable String text) {
        if (Strings.isNullOrEmpty(text)) {
            this.text = "&nbsp;";
        } else {
            this.setText(text);
        }
        return this;
    }

    public void addChildren(@Nonnull List<HtmlTag> content) {
        Preconditions.checkNotNull(content);
        this.children.addAll(content);
    }

    public record SelectOption(String text, String value) {
    }

    public record InputAttribute(String name, String value) {
    }
}

